﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;

using MicroRWD.QT;

namespace MicroRWD.UI.QT
{
    public partial class DataPanel : UserControl
    {
        #region Constructor

        public DataPanel()
        {
            InitializeComponent();
        }

        #endregion

        public void SetVisible(bool _visible)
        {
            Visible = _visible;

            if (_visible)
            {
                // Update view(s)
                UpdateTagPage();
                UpdatePictureBox();
            }
        }

        #region Private Methods

        // Update tag page depending on mode
        private void UpdateTagPage()
        {
            // TAG
            switch (Program.Controller.Reader.Mode)
            {
                case Mode.HITAG1_S:
                    hitag1_S_MemoryPanel.Visible = true;
                    hitag2_MemoryPanel.Visible = false;
                    h400X_MemoryPanel.Visible = false;
                    mc200_MemoryPanel.Visible = false;
                    break;

                case Mode.HITAG2:
                    hitag1_S_MemoryPanel.Visible = false;
                    hitag2_MemoryPanel.Visible = true;
                    h400X_MemoryPanel.Visible = false;
                    mc200_MemoryPanel.Visible = false;
                    break;

                case Mode.EM400X:
                    hitag1_S_MemoryPanel.Visible = false;
                    hitag2_MemoryPanel.Visible = false;
                    h400X_MemoryPanel.Visible = true;
                    mc200_MemoryPanel.Visible = false;
                    break;

                case Mode.MC200:
                    hitag1_S_MemoryPanel.Visible = false;
                    hitag2_MemoryPanel.Visible = false;
                    h400X_MemoryPanel.Visible = false;
                    mc200_MemoryPanel.Visible = true;
                    break;

                default:
                    hitag1_S_MemoryPanel.Visible = false;
                    hitag2_MemoryPanel.Visible = false;
                    h400X_MemoryPanel.Visible = false;
                    mc200_MemoryPanel.Visible = false;
                    break;
            }
        }

        // Update picture box depending on mode and tab select
        private void UpdatePictureBox()
        {
            if (tabControl.SelectedIndex == 0)
            {
                // TAG
                switch (Program.Controller.Reader.Mode)
                {
                    case Mode.HITAG1_S:
                        pictureBox.Image = global::MicroRWD.UI.QT.Properties.Resources.Hitag1;
                        break;

                    case Mode.HITAG2:
                        pictureBox.Image = global::MicroRWD.UI.QT.Properties.Resources.Hitag2;
                        break;

                    case Mode.EM400X:
                        pictureBox.Image = global::MicroRWD.UI.QT.Properties.Resources.EM4102;
                        break;

                    case Mode.MC200:
                        pictureBox.Image = global::MicroRWD.UI.QT.Properties.Resources.MCRF200;
                        break;

                    default:
                        pictureBox.Image = null;
                        break;
                }
            }
            else
            {
                // MicroRWD
                pictureBox.Image = global::MicroRWD.UI.QT.Properties.Resources.MicroRWD;
            }
        }

        #endregion


        #region Event Handlers

        // Handle selected tab changed event
        private void tabControl_SelectedIndexChanged(object sender, EventArgs e)
        {
            // Update view(s)
            UpdateTagPage();
            UpdatePictureBox();
        }

        private void exitButton_Click(object sender, EventArgs e)
        {
            Program.Controller.Exit();
        }

        #endregion

        private void DataPanel_Load(object sender, EventArgs e)
        {
            // Update view(s) unless in design mode
            if (!DesignMode && (Program.Controller != null))
            {
                // Update view(s)
                UpdateTagPage();
                UpdatePictureBox();
            }
        }

    }
}
